/* ========================================== */
/* تفاعلات التوب بار */
/* ========================================== */

document.addEventListener('DOMContentLoaded', function() {
    
    // بيانات الدول
    const arabCountries = [
        { name: "الأردن", file: "jordan" },
        { name: "الإمارات", file: "united-arab-emirates" },
        { name: "البحرين", file: "bahrain" },
        { name: "الجزائر", file: "algeria" },
        { name: "السعودية", file: "saudi-arabia" },
        { name: "السودان", file: "sudan" },
        { name: "الصومال", file: "somalia" },
        { name: "العراق", file: "iraq" },
        { name: "الكويت", file: "kuwait" },
        { name: "المغرب", file: "morocco" },
        { name: "اليمن", file: "yemen" },
        { name: "تونس", file: "tunisia" },
        { name: "جزر القمر", file: "comoros" },
        { name: "جيبوتي", file: "djibouti" },
        { name: "سوريا", file: "syria" },
        { name: "عمان", file: "oman" },
        { name: "فلسطين", file: "palestine" },
        { name: "قطر", file: "qatar" },
        { name: "لبنان", file: "lebanon" },
        { name: "ليبيا", file: "libya" },
        { name: "مصر", file: "egypt" },
        { name: "موريتانيا", file: "mauritania" }
    ];

    arabCountries.sort((a, b) => a.name.localeCompare(b, 'ar'));

    // ملء قائمة الدول في الديسكتوب
    const countrySelectDesktop = document.getElementById('countrySelectDesktop');
    if (countrySelectDesktop) {
        arabCountries.forEach(country => {
            const option = document.createElement('option');
            option.value = country.file;
            option.textContent = country.name;
            countrySelectDesktop.appendChild(option);
        });
    }

    // البحث في الديسكتوب
    const searchInput = document.querySelector('.search-input');
    const searchBtn = document.querySelector('.search-btn');
    const categorySelect = document.getElementById('categorySelect');

    function performSearch() {
        if (!searchInput) return;
        const query = searchInput.value.trim();
        const category = categorySelect ? categorySelect.value : 'all';
        const country = countrySelectDesktop ? countrySelectDesktop.value : 'all';
        
        if (query) {
            console.log('البحث عن:', query, '| التصنيف:', category, '| الدولة:', country);
        }
    }

    if (searchBtn) {
        searchBtn.addEventListener('click', performSearch);
    }
    
    if (searchInput) {
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                performSearch();
            }
        });
    }

    // ========================================
    // Modal الدول للموبايل
    // ========================================

    const countriesTrigger = document.querySelector('.countries-trigger');
    const countriesModal = document.getElementById('countriesModal');
    const closeModalBtn = document.querySelector('.close-modal');
    const modalOverlay = document.querySelector('.modal-overlay');

    // ملء قائمة الدول في Modal الموبايل
    const mobileCountryList = document.getElementById('mobileCountryList');
    if (mobileCountryList) {
        arabCountries.forEach(country => {
            const li = document.createElement('li');
            li.innerHTML = `
                <a href="#">
                    <img src="img/flag/${country.file}.png" alt="علم ${country.name}">
                    <span>${country.name}</span>
                </a>
            `;
            mobileCountryList.appendChild(li);
        });
    }

    // فتح Modal الدول
    if (countriesTrigger && countriesModal) {
        countriesTrigger.addEventListener('click', function() {
            countriesModal.classList.add('active');
            document.body.style.overflow = 'hidden';
        });
    }

    // إغلاق Modal الدول
    function closeCountriesModal() {
        if (countriesModal) {
            countriesModal.classList.remove('active');
            document.body.style.overflow = '';
        }
    }

    if (closeModalBtn) {
        closeModalBtn.addEventListener('click', closeCountriesModal);
    }

    if (modalOverlay) {
        modalOverlay.addEventListener('click', closeCountriesModal);
    }

    // البحث في Modal الدول
    const mobileCountrySearchInput = document.getElementById('mobileCountrySearchInput');
    if (mobileCountrySearchInput && mobileCountryList) {
        mobileCountrySearchInput.addEventListener('input', function() {
            const searchTerm = this.value.trim().toLowerCase();
            const items = mobileCountryList.querySelectorAll('li');
            
            items.forEach(item => {
                const text = item.textContent.toLowerCase();
                if (text.includes(searchTerm)) {
                    item.style.display = '';
                } else {
                    item.style.display = 'none';
                }
            });
        });
    }

    // ========================================
    // Modal البحث للموبايل والآيباد
    // ========================================

    const searchTrigger = document.querySelector('.search-trigger');
    const searchModal = document.getElementById('searchModal');
    const closeSearchModalBtn = document.querySelector('.close-search-modal');
    const searchModalOverlay = document.querySelector('.search-modal-overlay');

    // فتح Modal البحث
    if (searchTrigger && searchModal) {
        searchTrigger.addEventListener('click', function() {
            searchModal.classList.add('active');
            document.body.style.overflow = 'hidden';
            
            // Focus على input البحث
            const searchInputModal = document.querySelector('.search-input-modal');
            if (searchInputModal) {
                setTimeout(() => searchInputModal.focus(), 300);
            }
        });
    }

    // إغلاق Modal البحث
    function closeSearchModal() {
        if (searchModal) {
            searchModal.classList.remove('active');
            document.body.style.overflow = '';
        }
    }

    if (closeSearchModalBtn) {
        closeSearchModalBtn.addEventListener('click', closeSearchModal);
    }

    if (searchModalOverlay) {
        searchModalOverlay.addEventListener('click', closeSearchModal);
    }

    // البحث في Modal
    const searchBtnModal = document.querySelector('.search-btn-modal');
    const searchInputModal = document.querySelector('.search-input-modal');

    function performMobileSearch() {
        if (!searchInputModal) return;
        const query = searchInputModal.value.trim();
        
        if (query) {
            console.log('البحث في الموبايل عن:', query);
            closeSearchModal();
        }
    }

    if (searchBtnModal) {
        searchBtnModal.addEventListener('click', performMobileSearch);
    }

    if (searchInputModal) {
        searchInputModal.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                performMobileSearch();
            }
        });
    }
});
