/**
 * ========================================
 * CATEGORIES SWIPER - Coverflow Effect
 * ========================================
 */

document.addEventListener('DOMContentLoaded', function () {
  // تحقق من وجود Swiper
  if (typeof Swiper === 'undefined') {
    console.error('Swiper library not loaded!');
    return;
  }

  // اختيار جميع السلايدرات
  const swipers = document.querySelectorAll('.category-flat-swiper');

  if (swipers.length === 0) {
    console.warn('No swiper elements found');
    return;
  }

  // تفعيل كل سلايدر
  swipers.forEach((el, index) => {
    try {
      new Swiper(el, {
        // Effect: Coverflow للحصول على التأثير ثلاثي الأبعاد
        effect: 'coverflow',
        
        // المؤشر على شكل يد
        grabCursor: true,
        
        // توسيط الكارت النشط
        centeredSlides: true,
        
        // عرض تلقائي
        slidesPerView: 'auto',
        
        // إعدادات Coverflow
        coverflowEffect: {
          rotate: 0,          // بدون دوران
          stretch: 0,         // المسافة الأفقية بين الكروت
          depth: 150,         // عمق التأثير (كلما زاد = كلما الكروت راحت لورا أكتر)
          modifier: 1.5,      // قوة التأثير
          slideShadows: false // بدون ظلال على الكروت نفسها
        },
        
        // Loop لا نهائي
        loop: true,
        
        // سرعة الانتقال
        speed: 700,

        // Autoplay
        autoplay: {
          delay: 2500,
          disableOnInteraction: false,
          pauseOnMouseEnter: true
        },

        // Pagination
        pagination: {
          el: el.querySelector('.swiper-pagination'),
          clickable: true
        },

        // Responsive breakpoints
        breakpoints: {
          0: {
            slidesPerView: 'auto',
            coverflowEffect: {
              depth: 80,
              modifier: 1
            }
          },
          768: {
            slidesPerView: 'auto',
            coverflowEffect: {
              depth: 150,
              modifier: 1.5
            }
          }
        },

        // Events
        on: {
          init: function () {
            console.log(`Coverflow Swiper ${index + 1} initialized`);
          }
        }
      });
    } catch (error) {
      console.error(`Error initializing swiper ${index + 1}:`, error);
    }
  });
});
