// ========================================
// صفحة تفاصيل المنتج
// ========================================

document.addEventListener('DOMContentLoaded', function() {

    // ========================================
    // تبديل الصور المصغرة
    // ========================================
    const mainImage = document.getElementById('mainImage');
    const thumbnails = document.querySelectorAll('.thumbnail');

    thumbnails.forEach(thumb => {
        thumb.addEventListener('click', function() {
            // إزالة active من الكل
            thumbnails.forEach(t => t.classList.remove('active'));
            // إضافة active للمحدد
            this.classList.add('active');
            
            // تغيير الصورة الرئيسية
            const newSrc = this.querySelector('img').src.replace('150', '800').replace('150', '1000');
            mainImage.src = newSrc;
        });
    });

    // ========================================
    // زر المفضلة
    // ========================================
    const wishlistBtn = document.querySelector('.wishlist-btn');
    
    if (wishlistBtn) {
        wishlistBtn.addEventListener('click', function() {
            this.classList.toggle('active');
            const icon = this.querySelector('i');
            
            if (this.classList.contains('active')) {
                icon.classList.remove('far');
                icon.classList.add('fas');
            } else {
                icon.classList.remove('fas');
                icon.classList.add('far');
            }
        });
    }

    // ========================================
    // اختيار اللون
    // ========================================
    const colorItems = document.querySelectorAll('.color-item');
    const colorValueSpan = document.querySelector('.product-option .selected-value');

    colorItems.forEach(item => {
        item.addEventListener('click', function() {
            colorItems.forEach(c => c.classList.remove('active'));
            this.classList.add('active');
            
            const colorName = this.dataset.color;
            colorValueSpan.textContent = colorName;
        });
    });

    // ========================================
    // اختيار المقاس
    // ========================================
    const sizeItems = document.querySelectorAll('.size-item');
    const sizeValueSpan = document.querySelectorAll('.product-option .selected-value')[1];

    sizeItems.forEach(item => {
        item.addEventListener('click', function() {
            sizeItems.forEach(s => s.classList.remove('active'));
            this.classList.add('active');
            
            const sizeName = this.dataset.size;
            if (sizeValueSpan) {
                sizeValueSpan.textContent = sizeName;
            }
        });
    });

    // ========================================
    // زر الاتصال والـ Dropdown
    // ========================================
    const contactBtn = document.getElementById('contactBtn');
    const contactDropdown = document.getElementById('contactDropdown');

    if (contactBtn && contactDropdown) {
        contactBtn.addEventListener('click', function(e) {
            e.stopPropagation();
            this.classList.toggle('active');
            contactDropdown.classList.toggle('active');
        });

        // إغلاق الـ dropdown عند الضغط خارجه
        document.addEventListener('click', function(e) {
            if (!contactDropdown.contains(e.target) && e.target !== contactBtn) {
                contactBtn.classList.remove('active');
                contactDropdown.classList.remove('active');
            }
        });

        // منع إغلاق الـ dropdown عند الضغط داخله
        contactDropdown.addEventListener('click', function(e) {
            e.stopPropagation();
        });
    }

    // ========================================
    // التبويبات
    // ========================================
    const tabBtns = document.querySelectorAll('.tab-btn');
    const tabPanels = document.querySelectorAll('.tab-panel');

    tabBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            const targetTab = this.dataset.tab;
            
            // إزالة active من الكل
            tabBtns.forEach(b => b.classList.remove('active'));
            tabPanels.forEach(p => p.classList.remove('active'));
            
            // إضافة active للمحدد
            this.classList.add('active');
            document.getElementById(targetTab).classList.add('active');
        });
    });

    // ========================================
    // زر "مفيد" في التقييمات
    // ========================================
    const helpfulBtns = document.querySelectorAll('.helpful-btn');
    
    helpfulBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            this.classList.toggle('active');
            const icon = this.querySelector('i');
            
            if (this.classList.contains('active')) {
                icon.classList.remove('far');
                icon.classList.add('fas');
                this.style.background = '#b42f4c';
                this.style.color = '#fff';
                this.style.borderColor = '#b42f4c';
            } else {
                icon.classList.remove('fas');
                icon.classList.add('far');
                this.style.background = '#fff';
                this.style.color = '#666';
                this.style.borderColor = '#e0e0e0';
            }
        });
    });

});
