/* ========================================== */
/* تفاعلات الناف بار */
/* ========================================== */

document.addEventListener('DOMContentLoaded', function () {

  // بيانات الدول
  const arabCountries = [
    { name: "الأردن", file: "jordan" },
    { name: "الإمارات", file: "united-arab-emirates" },
    { name: "البحرين", file: "bahrain" },
    { name: "الجزائر", file: "algeria" },
    { name: "السعودية", file: "saudi-arabia" },
    { name: "السودان", file: "sudan" },
    { name: "الصومال", file: "somalia" },
    { name: "العراق", file: "iraq" },
    { name: "الكويت", file: "kuwait" },
    { name: "المغرب", file: "morocco" },
    { name: "اليمن", file: "yemen" },
    { name: "تونس", file: "tunisia" },
    { name: "جزر القمر", file: "comoros" },
    { name: "جيبوتي", file: "djibouti" },
    { name: "سوريا", file: "syria" },
    { name: "عمان", file: "oman" },
    { name: "فلسطين", file: "palestine" },
    { name: "قطر", file: "qatar" },
    { name: "لبنان", file: "lebanon" },
    { name: "ليبيا", file: "libya" },
    { name: "مصر", file: "egypt" },
    { name: "موريتانيا", file: "mauritania" }
  ];

  arabCountries.sort((a, b) => a.name.localeCompare(b.name, 'ar'));

  const countryList = document.getElementById('countryList');
  const searchInput = document.getElementById('countrySearchInput');

  // عرض الدول في Nav Bar
  function renderCountries(list) {
    if (!countryList) return;

    countryList.innerHTML = '';
    list.forEach(country => {
      const li = document.createElement('li');
      li.innerHTML = `
        <a href="#">
          <img src="img/flag/${country.file}.png" alt="علم ${country.name}" class="country-flag">
          <span>${country.name}</span>
        </a>
      `;
      countryList.appendChild(li);
    });
  }

  renderCountries(arabCountries);

  // البحث عن الدولة
  if (searchInput) {
    searchInput.addEventListener('input', function (e) {
      const query = e.target.value.trim();
      const filteredCountries = arabCountries.filter(country =>
        country.name.includes(query)
      );
      renderCountries(filteredCountries);
    });
  }

  // قائمة الموبايل (الهامبرغر)
  const menuToggle = document.querySelector('.menu-toggle');
  const mainNav = document.querySelector('.main-nav');
  const dropdowns = document.querySelectorAll('.dropdown');

  function isMobile() {
    return window.matchMedia('(max-width: 992px)').matches;
  }

  function closeAllDropdowns() {
    dropdowns.forEach(dd => dd.classList.remove('active'));
  }

  // فتح/إغلاق المينيو
  if (menuToggle && mainNav) {
    menuToggle.addEventListener('click', function (e) {
      e.stopPropagation();
      mainNav.classList.toggle('active');

      if (!mainNav.classList.contains('active')) {
        closeAllDropdowns();
      }
    });
  }

  // فتح/إغلاق القوائم الفرعية في الموبايل
  dropdowns.forEach(dropdown => {
    const toggle = dropdown.querySelector('.dropdown-toggle');
    
    if (toggle) {
      toggle.addEventListener('click', function (e) {
        if (!isMobile()) return;
        e.preventDefault();
        e.stopPropagation();
        
        // إغلاق باقي القوائم
        dropdowns.forEach(dd => {
          if (dd !== dropdown) dd.classList.remove('active');
        });
        
        dropdown.classList.toggle('active');
      });
    }
  });

  // إغلاق القوائم عند الضغط بره
  document.addEventListener('click', function (e) {
    if (!isMobile()) return;
    if (!mainNav || !mainNav.classList.contains('active')) return;

    const isClickInside = mainNav.contains(e.target) || menuToggle.contains(e.target);
    if (!isClickInside) {
      closeAllDropdowns();
    }
  });

  // تنظيف عند Resize
  window.addEventListener('resize', function () {
    if (!isMobile()) {
      closeAllDropdowns();
      if (mainNav) mainNav.classList.remove('active');
    }
  });

});
