/* ========================================== */
/* تفعيل Swiper Slider */
/* ========================================== */

document.addEventListener('DOMContentLoaded', function() {
    
    var swiper = new Swiper(".hero-swiper", {
        // الاتجاه RTL
        dir: "rtl",
        
        // تأثير التلاشي (Fade) يعطي فخامة أكثر من السحب العادي
        effect: "fade", 
        fadeEffect: {
            crossFade: true
        },

        // التشغيل التلقائي كل 3 ثواني
        autoplay: {
            delay: 3000,
            disableOnInteraction: false, // يستمر حتى لو المستخدم لمس السلايدر
            pauseOnMouseEnter: true      // يوقف لما الماوس ييجي عليه
        },

        // السرعة
        speed: 800,
        
        // الدوران اللانهائي
        loop: true,

        // نقاط التنقل (Dots)
        pagination: {
            el: ".swiper-pagination",
            clickable: true,
            dynamicBullets: true,
        },

        // أسهم التنقل
        navigation: {
            nextEl: ".swiper-button-prev", // معكوسة في الـ RTL
            prevEl: ".swiper-button-next",
        },
    });

});
