document.addEventListener('DOMContentLoaded', function() {

    const switchFormBtns = document.querySelectorAll('.switch-form, .forgot-link');
    const formContainers = document.querySelectorAll('.form-container');

    switchFormBtns.forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            const targetForm = this.dataset.form;
            formContainers.forEach(form => form.classList.remove('active'));
            document.getElementById(targetForm).classList.add('active');
        });
    });

    const togglePasswordBtns = document.querySelectorAll('.toggle-password');
    togglePasswordBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            const input = this.previousElementSibling;
            const icon = this.querySelector('i');
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });
    });

    const registerPassword = document.getElementById('registerPassword');
    if (registerPassword) {
        const strengthBar = document.querySelector('.strength-fill');
        const strengthText = document.querySelector('.strength-text');
        registerPassword.addEventListener('input', function() {
            const password = this.value;
            let strength = 0;
            if (password.length >= 8) strength++;
            if (password.match(/[a-z]/)) strength++;
            if (password.match(/[A-Z]/)) strength++;
            if (password.match(/[0-9]/)) strength++;
            if (password.match(/[^a-zA-Z0-9]/)) strength++;
            strengthBar.className = 'strength-fill';
            if (strength <= 2) {
                strengthBar.classList.add('weak');
                strengthText.textContent = 'ضعيفة';
                strengthText.style.color = '#dc2626';
            } else if (strength <= 4) {
                strengthBar.classList.add('medium');
                strengthText.textContent = 'متوسطة';
                strengthText.style.color = '#f59e0b';
            } else {
                strengthBar.classList.add('strong');
                strengthText.textContent = 'قوية';
                strengthText.style.color = '#15803d';
            }
        });
    }

    const confirmPassword = document.getElementById('registerConfirmPassword');
    if (confirmPassword) {
        confirmPassword.addEventListener('input', function() {
            const password = registerPassword.value;
            const confirm = this.value;
            const formGroup = this.closest('.form-group');
            if (confirm && password !== confirm) {
                formGroup.classList.add('error');
                this.classList.add('error');
            } else {
                formGroup.classList.remove('error');
                this.classList.remove('error');
                if (confirm && password === confirm) {
                    this.classList.add('success');
                }
            }
        });
    }

    const emailInputs = document.querySelectorAll('input[type="email"]');
    emailInputs.forEach(input => {
        input.addEventListener('blur', function() {
            const email = this.value;
            const formGroup = this.closest('.form-group');
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (email && !emailRegex.test(email)) {
                formGroup.classList.add('error');
                this.classList.add('error');
            } else {
                formGroup.classList.remove('error');
                this.classList.remove('error');
                if (email) {
                    this.classList.add('success');
                }
            }
        });
    });

    const phoneInput = document.getElementById('registerPhone');
    if (phoneInput) {
        phoneInput.addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9+\s]/g, '');
        });
        phoneInput.addEventListener('blur', function() {
            const phone = this.value.replace(/\s/g, '');
            const formGroup = this.closest('.form-group');
            if (phone && phone.length < 10) {
                formGroup.classList.add('error');
                this.classList.add('error');
            } else {
                formGroup.classList.remove('error');
                this.classList.remove('error');
                if (phone) {
                    this.classList.add('success');
                }
            }
        });
    }

    const loginForm = document.querySelector('#loginForm .auth-form');
    if (loginForm) {
        loginForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const email = document.getElementById('loginEmail').value;
            const password = document.getElementById('loginPassword').value;
            console.log('Login:', { email, password });
            alert('تم تسجيل الدخول بنجاح!');
            window.location.href = 'index.html';
        });
    }

    const registerFormEl = document.querySelector('#registerForm .auth-form');
    if (registerFormEl) {
        registerFormEl.addEventListener('submit', function(e) {
            e.preventDefault();
            const name = document.getElementById('registerName').value;
            const email = document.getElementById('registerEmail').value;
            const phone = document.getElementById('registerPhone').value;
            const password = document.getElementById('registerPassword').value;
            const confirmPass = document.getElementById('registerConfirmPassword').value;
            const agree = document.getElementById('agreeTerms').checked;
            if (!name || !email || !phone || !password || !confirmPass) {
                alert('جميع الحقول مطلوبة');
                return;
            }
            if (password !== confirmPass) {
                alert('كلمة المرور غير متطابقة');
                return;
            }
            if (!agree) {
                alert('يجب الموافقة على الشروط والأحكام');
                return;
            }
            console.log('Register:', { name, email, phone, password });
            alert('تم إنشاء حسابك بنجاح!');
            window.location.href = 'index.html';
        });
    }

    const forgotFormEl = document.querySelector('#forgotForm .auth-form');
    if (forgotFormEl) {
        forgotFormEl.addEventListener('submit', function(e) {
            e.preventDefault();
            const email = document.getElementById('forgotEmail').value;
            if (!email) {
                alert('البريد الإلكتروني مطلوب');
                return;
            }
            console.log('Forgot Password:', { email });
            const successMsg = this.querySelector('.success-message');
            if (successMsg) {
                successMsg.style.display = 'flex';
                setTimeout(() => {
                    successMsg.style.display = 'none';
                }, 5000);
            }
        });
    }

    const socialBtns = document.querySelectorAll('.social-btn');
    socialBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            const provider = this.classList.contains('google') ? 'Google' : 'Facebook';
            console.log(`Login with ${provider}`);
            alert(`سيتم التوجيه لتسجيل الدخول عبر ${provider}`);
        });
    });

});
